//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3

import wesual.Controls         1.0
import wesual.data.Core        1.0

SuggestionBox {
    id : tagPicker

    property TaggableDocument   document
    property DocumentListFilter tags

    StringFilter {
        id : inputFilter
        property : "name"
        Component.onCompleted: {
            tags.filters = [inputFilter];
        }
    }

    displayPropertyName : "name"
    width : parent.width
    placeholderText : qsTrId("64837f202e23d583")

    model : tags.resultingDocuments

    filter : inputFilter
    popupHeight : 200
    popupWillScroll : true

    delegate : SuggestionBoxDelegate {
        Row {
            width : parent.width
            height : 26
            spacing : 3
            anchors {
                left : parent.left
                leftMargin : 3
                right : parent.right
                rightMargin : 3
            }

            TagIcon {
                id : tagImg
                width : 20
                height : 20
                tag : document
                tintColor : "black"
                anchors.verticalCenter : parent.verticalCenter
            }
            Text {
                id : label
                text : document ?
                       document[view.displayPropertyName] : ""
                anchors.verticalCenter : parent.verticalCenter
            }
        }
    }
    onDocumentChanged : {
        if (tagPicker.document && chosenDocument)
            tagPicker.document.addTag(chosenDocument);
    }

}
